<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    /**
     * Run the migrations.
     * 
     * This migration drops all old financial system tables:
     * - accounts, account_transactions, transactions
     * - customers, cashiers, cashier_shifts
     * - currencies, currency_trades, currency_rate_history
     * - transaction_fees, daily_balance_reports
     */
    public function up(): void
    {
        // Disable foreign key checks temporarily to avoid constraint errors
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        // Drop old financial system tables in reverse order of dependencies
        // Start with tables that have foreign keys to others
        
        // Transaction-related tables
        Schema::dropIfExists('transaction_fees');
        Schema::dropIfExists('account_transactions');
        Schema::dropIfExists('transactions');
        
        // Account-related tables
        Schema::dropIfExists('accounts');
        
        // Customer-related tables
        Schema::dropIfExists('customers');
        
        // Cashier-related tables
        Schema::dropIfExists('cashier_shifts');
        Schema::dropIfExists('cashiers');
        
        // Currency-related tables
        Schema::dropIfExists('currency_trades');
        Schema::dropIfExists('daily_balance_reports');
        Schema::dropIfExists('currency_rate_history');
        Schema::dropIfExists('currencies');

        // Re-enable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // This migration is irreversible by design
        // If you need to restore, you would need to restore from backup
    }
};
