<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
    {
        Schema::table('daily_balance_reports', function (Blueprint $table) {
            // Add a longText column to store the base64 encoded image data
            $table->longText('image')->nullable()->after('converted_iqd_to_usd');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('daily_balance_reports', function (Blueprint $table) {
            $table->dropColumn('image');
        });
    }
};
