<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up()
    {
        Schema::table('daily_balance_reports', function (Blueprint $table) {
            // Profit tracking columns
            $table->decimal('profit_amount', 15, 2)->default(0)->after('grand_total_usd');
            $table->string('profit_currency', 10)->nullable()->after('profit_amount');
            
            // Conversion tracking columns
            $table->decimal('usd_to_iqd_rate', 15, 4)->nullable()->after('profit_currency');
            $table->decimal('iqd_to_usd_rate', 15, 4)->nullable()->after('usd_to_iqd_rate');
            $table->decimal('converted_usd_to_iqd', 15, 2)->default(0)->after('iqd_to_usd_rate');
            $table->decimal('converted_iqd_to_usd', 15, 2)->default(0)->after('converted_usd_to_iqd');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('daily_balance_reports', function (Blueprint $table) {
            $table->dropColumn([
                'profit_amount',
                'profit_currency',
                'usd_to_iqd_rate',
                'iqd_to_usd_rate',
                'converted_usd_to_iqd',
                'converted_iqd_to_usd'
            ]);
        });
    }
};
