<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // In the migration file
        Schema::create('daily_balance_reports', function (Blueprint $table) {
            $table->id();
            $table->date('report_date')->unique();
            $table->decimal('total_iqd', 15, 2);
            $table->decimal('total_usd', 15, 2);
            $table->decimal('total_euro', 15, 2);
            $table->decimal('euro_to_usd_rate', 15, 6)->nullable();
            $table->decimal('converted_euro_to_usd', 15, 2)->nullable();
            $table->json('additional_currencies')->nullable();
            $table->decimal('total_additional_usd', 15, 2)->nullable();
            $table->decimal('grand_total_usd', 15, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('daily_balance_reports');
    }
};
