<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            $table->string('sender_name')->nullable()->after('person_name');
            $table->string('receiver_name')->nullable()->after('sender_name');
            $table->string('sender_phone')->nullable()->after('receiver_name');
            $table->string('receiver_phone')->nullable()->after('sender_phone');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            $table->dropColumn(['sender_name', 'receiver_name', 'sender_phone', 'receiver_phone']);
        });
    }
};
