<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('approved')->after('transaction_category');
        });

        // Update existing transactions to be 'approved'
        DB::table('account_transactions')->update(['status' => 'approved']);

        Schema::table('customers', function (Blueprint $table) {
            $table->boolean('requires_approval')->default(false)->after('customer_name');
        });
    }

    public function down()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            $table->dropColumn('status');
        });

        Schema::table('customers', function (Blueprint $table) {
            $table->dropColumn('requires_approval');
        });
    }
};
