<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            // Add the new optional columns
            $table->decimal('exchange_rate', 10, 4)->nullable();  // Add nullable exchange_rate
            $table->enum('transaction_category', ['buy', 'sell'])->nullable();  // Add nullable transaction_category (buy or sell)
        });
    }

    public function down()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            // Rollback the changes by dropping the added columns
            $table->dropColumn('exchange_rate');
            $table->dropColumn('transaction_category');
        });
    }
};
