<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            // Adding transaction_id column (nullable)
            $table->string('transaction_id')->nullable()->after('id'); // `nullable` ensures that it's optional
        });
    }

    public function down()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            // Rolling back the migration (removes the transaction_id column)
            $table->dropColumn('transaction_id');
        });
    }
};
