<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('files', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->string('file_path'); // Path to the file (string)
            $table->text('note')->nullable();
            // Polymorphic columns
            $table->unsignedBigInteger('fileable_id'); // Morphable model's ID
            $table->string('fileable_type'); // Morphable model's class (type)
            
            $table->timestamps(); // Timestamps (created_at, updated_at)
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('files');
    }
};
