<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Modify the 'to_currency' column to be nullable
            $table->unsignedBigInteger('to_currency')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Revert the 'to_currency' column to be non-nullable
            $table->unsignedBigInteger('to_currency')->nullable(false)->change();
        });
    }
};
