<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            // Add from_account_id and to_account_id columns
            $table->unsignedBigInteger('from_account_id')->nullable();
            $table->unsignedBigInteger('to_account_id')->nullable();

            // Optional: Add foreign key constraints to reference the accounts table
            $table->foreign('from_account_id')->references('id')->on('accounts')->onDelete('set null');
            $table->foreign('to_account_id')->references('id')->on('accounts')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('account_transactions', function (Blueprint $table) {
            // Drop the foreign keys first if they exist
            $table->dropForeign(['from_account_id']);
            $table->dropForeign(['to_account_id']);

            // Drop the from_account_id and to_account_id columns
            $table->dropColumn('from_account_id');
            $table->dropColumn('to_account_id');
        });
    }
};
