<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('cashier_shift_id');
            $table->date('transaction_date');
            $table->time('transaction_time');
            $table->decimal('transaction_amount', 15, 2);
            $table->enum('transaction_type', ['sell', 'buy']);
            $table->unsignedBigInteger('from_currency');
            $table->unsignedBigInteger('to_currency');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
