<?php

namespace Database\Factories;

use Illuminate\Support\Str;
use App\Models\CashierShift;
use Illuminate\Database\Eloquent\Factories\Factory;

class CashierShiftFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = CashierShift::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'start_time' => $this->faker->time(),
            'end_time' => $this->faker->time(),
            'starting_amount' => $this->faker->randomNumber(1),
            'ending_amount' => $this->faker->randomNumber(1),
            'cashier_id' => \App\Models\Cashier::factory(),
            'supervisor_id' => \App\Models\User::factory(),
        ];
    }
}
