<?php

namespace Database\Factories;

use App\Models\Cashier;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

class CashierFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Cashier::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'cashier_name' => $this->faker->sentence(10),
            'start_time' => $this->faker->time(),
            'end_time' => $this->faker->time(),
            'cashier_type' => 'supervisor',
            'user_id' => \App\Models\User::factory(),
        ];
    }
}
