<?php

namespace Database\Factories;

use Illuminate\Support\Str;
use App\Models\AccountTransaction;
use Illuminate\Database\Eloquent\Factories\Factory;

class AccountTransactionFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AccountTransaction::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'transaction_type' => 'deposit',
            'transaction_amount' => $this->faker->randomNumber(1),
            'transaction_date' => $this->faker->date(),
            'transaction_time' => $this->faker->time(),
            'note' => $this->faker->text(),
            'account_id' => \App\Models\Account::factory(),
            'user_id' => \App\Models\User::factory(),
        ];
    }
}
