<?php

namespace Database\Factories;

use App\Models\Account;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

class AccountFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Account::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'account_title' => $this->faker->text(255),
            'account_number' => $this->faker->text(255),
            'balance' => $this->faker->randomNumber(1),
            'account_type' => 'savings',
            'customer_id' => \App\Models\Customer::factory(),
            'currency_id' => \App\Models\Currency::factory(),
        ];
    }
}
