<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Kurdish Text Corruption Mappings
    |--------------------------------------------------------------------------
    |
    | This file contains mappings for known corrupted Kurdish text patterns.
    | When the API encounters corrupted text (containing ?), it will check
    | this mapping to see if there's a known correct replacement.
    |
    | Format: 'corrupted_text' => 'correct_kurdish_text'
    |
    */

    'mappings' => [
        // Transaction 129518
        '???? ???' => 'ئاسۆ کوی',
        
        // Add more mappings here as you discover corrupted data
        // Example:
        // '???' => 'کارتی Qi',
        // '?? ????' => 'ڕێنماییەکان',
    ],

    /*
    |--------------------------------------------------------------------------
    | Auto-fix Settings
    |--------------------------------------------------------------------------
    |
    | Configure how the system should handle corrupted text
    |
    */

    'auto_fix_enabled' => true,
    
    // What to return when corrupted text cannot be fixed
    // Options: 'null', 'empty', 'original'
    'unfixable_return' => 'null',
    
    // Encodings to try when attempting to fix corruption
    'try_encodings' => [
        'Windows-1256',
        'ISO-8859-6',
        'CP1256',
    ],
];



