#!/bin/bash

echo "=========================================="
echo " Clearing Laravel Caches"
echo "=========================================="

# Find PHP executable
PHP_BIN=$(which php)

if [ -z "$PHP_BIN" ]; then
    # Try common paths
    if [ -f "/Applications/MAMP/bin/php/php8.2.0/bin/php" ]; then
        PHP_BIN="/Applications/MAMP/bin/php/php8.2.0/bin/php"
    elif [ -f "/Applications/MAMP/bin/php/php8.1.0/bin/php" ]; then
        PHP_BIN="/Applications/MAMP/bin/php/php8.1.0/bin/php"
    elif [ -f ~/.config/herd/bin/php ]; then
        PHP_BIN="$HOME/.config/herd/bin/php"
    else
        echo "❌ PHP not found! Please run manually:"
        echo "   php artisan config:clear"
        echo "   php artisan cache:clear"
        echo "   php artisan route:clear"
        echo "   php artisan view:clear"
        echo "   composer dump-autoload"
        exit 1
    fi
fi

echo "Using PHP: $PHP_BIN"
echo ""

echo "1. Clearing config cache..."
$PHP_BIN artisan config:clear

echo "2. Clearing application cache..."
$PHP_BIN artisan cache:clear

echo "3. Clearing route cache..."
$PHP_BIN artisan route:clear

echo "4. Clearing view cache..."
$PHP_BIN artisan view:clear

echo "5. Dumping autoload..."
$PHP_BIN ../composer.phar dump-autoload 2>/dev/null || composer dump-autoload

echo ""
echo "=========================================="
echo " ✓ All caches cleared!"
echo "=========================================="
echo ""
echo "Now test your API in Postman:"
echo "GET https://LA DERMA.innovation-pulsehub.com/api/mobile/transactions"
echo ""



