<?php

/**
 * Check a specific user's OneSignal setup
 * Usage: php check_user_onesignal.php [user_id or email]
 */

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\User;

$identifier = $argv[1] ?? null;

if (!$identifier) {
    echo "Usage: php check_user_onesignal.php [user_id or email]\n";
    echo "Example: php check_user_onesignal.php admin@example.com\n";
    exit(1);
}

// Try to find user by ID or email
$user = is_numeric($identifier) 
    ? User::find($identifier)
    : User::where('email', $identifier)->first();

if (!$user) {
    echo "❌ User not found: {$identifier}\n";
    exit(1);
}

echo "═══════════════════════════════════════════════════════════════\n";
echo "   USER ONESIGNAL STATUS\n";
echo "═══════════════════════════════════════════════════════════════\n\n";

echo "User Information:\n";
echo "  ID: {$user->id}\n";
echo "  Name: {$user->name}\n";
echo "  Email: {$user->email}\n\n";

echo "Notification Settings:\n";
echo "  Notifications Enabled: " . ($user->notifications_enabled ? '✅ Yes' : '❌ No') . "\n";
echo "  Transaction Notifications: " . ($user->transaction_notifications ? '✅ Yes' : '❌ No') . "\n";
echo "  Currency Rate Notifications: " . ($user->currency_rate_notifications ? '✅ Yes' : '❌ No') . "\n";
echo "  Language Preference: " . ($user->language_preference ?? 'NULL') . "\n\n";

echo "OneSignal Integration:\n";
echo "  Player ID: " . ($user->onesignal_player_id ?? '❌ NOT SET') . "\n";
echo "  External ID: " . ($user->onesignal_external_id ?? '❌ NOT SET') . "\n\n";

if (!$user->onesignal_player_id && !$user->onesignal_external_id) {
    echo "⚠️  WARNING: This user will NOT receive push notifications!\n";
    echo "\nTo fix:\n";
    echo "1. User must log in to the mobile app\n";
    echo "2. Accept notification permissions when prompted\n";
    echo "3. App will automatically register with OneSignal\n";
} else {
    echo "✅ User is configured for push notifications!\n";
}

echo "\n═══════════════════════════════════════════════════════════════\n";













