<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\Notification;
use App\Models\User;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Checking notifications for user ID 228...\n\n";
    
    // Check if user 228 exists
    $user = User::find(228);
    if ($user) {
        echo "User 228 found: {$user->email}\n";
    } else {
        echo "User 228 not found\n";
    }
    
    // Get all notifications for user 228
    $notifications = Notification::where('user_id', 228)->orderBy('id', 'desc')->get();
    
    echo "Found {$notifications->count()} notifications for user 228\n\n";
    
    foreach ($notifications as $notification) {
        echo "=== Notification ID: {$notification->id} ===\n";
        echo "Title: {$notification->title}\n";
        echo "Body: {$notification->body}\n";
        echo "Body length: " . strlen($notification->body) . "\n";
        echo "Body bytes: " . implode(', ', array_map('ord', str_split($notification->body))) . "\n";
        
        // Check if body contains question marks
        if (strpos($notification->body, '?') !== false) {
            echo "⚠️ CORRUPTED - Contains question marks!\n";
        } else {
            echo "✅ CORRECT - No question marks\n";
        }
        
        echo "Type: {$notification->type}\n";
        echo "Created at: {$notification->created_at}\n";
        echo "\n";
    }
    
    // Also check all notifications in the database
    echo "=== ALL NOTIFICATIONS IN DATABASE ===\n";
    $allNotifications = Notification::orderBy('id', 'desc')->get();
    
    foreach ($allNotifications as $notification) {
        echo "ID: {$notification->id}, User: {$notification->user_id}, Body: {$notification->body}\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}







