<?php

/**
 * Check Real OneSignal Player IDs
 */

// Load Laravel environment
require_once 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;

echo "🔍 Checking Real OneSignal Player IDs\n";
echo "====================================\n\n";

// Get users with OneSignal player IDs
$users = User::whereNotNull('onesignal_player_id')->get();

echo "Users with OneSignal Player IDs: " . $users->count() . "\n\n";

if ($users->count() > 0) {
    echo "Player IDs found:\n";
    foreach ($users as $user) {
        echo "- User ID: {$user->id}, Name: {$user->name}, Player ID: {$user->onesignal_player_id}\n";
    }
    
    echo "\n";
    echo "Testing with real player IDs...\n";
    
    // Test with the first real player ID
    $firstUser = $users->first();
    $playerId = $firstUser->onesignal_player_id;
    
    echo "Testing with Player ID: {$playerId}\n";
    
    $appId = config('onesignal.app_id');
    $restApiKey = config('onesignal.rest_api_key');
    
    $url = "https://onesignal.com/api/v1/notifications";
    $payload = [
        'app_id' => $appId,
        'include_player_ids' => [$playerId],
        'contents' => ['en' => 'Test notification from Laravel - ' . date('Y-m-d H:i:s')],
        'data' => ['type' => 'test']
    ];
    
    $headers = [
        'Authorization: Basic ' . $restApiKey,
        'Content-Type: application/json'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        echo "❌ cURL Error: {$error}\n";
    } else {
        echo "HTTP Code: {$httpCode}\n";
        if ($httpCode === 200) {
            $data = json_decode($response, true);
            if (isset($data['errors'])) {
                echo "❌ OneSignal Errors:\n";
                foreach ($data['errors'] as $error) {
                    echo "   - {$error}\n";
                }
            } else {
                echo "✅ Success! Notification sent!\n";
                echo "Notification ID: " . ($data['id'] ?? 'Unknown') . "\n";
                echo "Recipients: " . ($data['recipients'] ?? 'Unknown') . "\n";
            }
        } else {
            echo "❌ Failed! Response: {$response}\n";
        }
    }
    
} else {
    echo "❌ No users have OneSignal player IDs!\n";
    echo "\nThis means:\n";
    echo "1. Users haven't opened the mobile app yet\n";
    echo "2. OneSignal isn't properly initialized in the mobile app\n";
    echo "3. Player IDs aren't being saved to the database\n";
    echo "\nTo fix this:\n";
    echo "1. Open the mobile app on a device\n";
    echo "2. Make sure OneSignal is working\n";
    echo "3. Check if player IDs are being saved to the database\n";
}

echo "\n✅ Check completed!\n";


