<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\Notification;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Checking raw notification data for user 228...\n\n";
    
    // Get raw data from database
    $rawNotifications = DB::table('notifications')
        ->where('user_id', 228)
        ->orderBy('id', 'desc')
        ->take(5)
        ->get();
    
    echo "Found {$rawNotifications->count()} notifications (raw query)\n\n";
    
    foreach ($rawNotifications as $notification) {
        echo "=== Notification ID: {$notification->id} ===\n";
        echo "Title: {$notification->title}\n";
        echo "Body: {$notification->body}\n";
        echo "Body length: " . strlen($notification->body) . "\n";
        echo "Body bytes: " . implode(', ', array_map('ord', str_split($notification->body))) . "\n";
        echo "Type: {$notification->type}\n";
        
        // Check for question marks using different methods
        echo "Contains '?': " . (strpos($notification->body, '?') !== false ? 'YES' : 'NO') . "\n";
        echo "Contains '?????': " . (strpos($notification->body, '?????') !== false ? 'YES' : 'NO') . "\n";
        
        // Check if body contains ASCII 63 (question mark character)
        $hasQuestionMarks = false;
        for ($i = 0; $i < strlen($notification->body); $i++) {
            if (ord($notification->body[$i]) == 63) {
                $hasQuestionMarks = true;
                break;
            }
        }
        echo "Contains ASCII 63: " . ($hasQuestionMarks ? 'YES' : 'NO') . "\n";
        
        echo "\n";
    }
    
    // Also try a different approach - check for notifications with body length 47
    echo "=== Checking notifications with body length 47 ===\n";
    $length47Notifications = DB::table('notifications')
        ->where('user_id', 228)
        ->whereRaw('CHAR_LENGTH(body) = 47')
        ->get();
    
    echo "Found {$length47Notifications->count()} notifications with body length 47\n";
    
    foreach ($length47Notifications->take(3) as $notification) {
        echo "ID: {$notification->id}, Body: {$notification->body}\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}







