<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\Notification;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Checking latest notifications in database...\n\n";
    
    $notifications = Notification::latest()->take(3)->get();
    
    foreach ($notifications as $notification) {
        echo "=== Notification ID: {$notification->id} ===\n";
        echo "Title: {$notification->title}\n";
        echo "Body: {$notification->body}\n";
        echo "Body length: " . strlen($notification->body) . "\n";
        echo "Body bytes: " . implode(', ', array_map('ord', str_split($notification->body))) . "\n";
        echo "JSON encoded: " . json_encode(['body' => $notification->body], JSON_UNESCAPED_UNICODE) . "\n";
        echo "Created at: {$notification->created_at}\n";
        echo "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}







