<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Checking all notifications in database...\n\n";
    
    // Get all notifications from database
    $allNotifications = DB::table('notifications')->get();
    
    echo "Found {$allNotifications->count()} total notifications in database\n\n";
    
    if ($allNotifications->count() > 0) {
        echo "Sample notifications:\n";
        foreach ($allNotifications->take(5) as $notification) {
            echo "ID: {$notification->id}, User: {$notification->user_id}, Title: {$notification->title}\n";
        }
        
        echo "\nUser distribution:\n";
        $userCounts = DB::table('notifications')
            ->select('user_id', DB::raw('count(*) as count'))
            ->groupBy('user_id')
            ->get();
            
        foreach ($userCounts as $userCount) {
            echo "User {$userCount->user_id}: {$userCount->count} notifications\n";
        }
    }
    
    // Check database connection info
    echo "\n=== Database Connection Info ===\n";
    $connection = DB::connection();
    echo "Database: " . $connection->getDatabaseName() . "\n";
    echo "Driver: " . $connection->getDriverName() . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}







