<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\Notification;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Checking all notifications in database...\n\n";
    
    // Get all notifications
    $notifications = Notification::orderBy('id', 'desc')->take(10)->get();
    
    echo "Found {$notifications->count()} recent notifications\n\n";
    
    foreach ($notifications as $notification) {
        echo "=== Notification ID: {$notification->id} ===\n";
        echo "Title: {$notification->title}\n";
        echo "Body: {$notification->body}\n";
        echo "Body length: " . strlen($notification->body) . "\n";
        echo "Body bytes: " . implode(', ', array_map('ord', str_split($notification->body))) . "\n";
        echo "Type: {$notification->type}\n";
        echo "Created at: {$notification->created_at}\n";
        
        // Check if body contains question marks
        if (strpos($notification->body, '?') !== false) {
            echo "⚠️ Contains question marks!\n";
        }
        
        // Check data field
        $data = $notification->data;
        if (is_string($data)) {
            $data = json_decode($data, true);
        }
        echo "Data: " . json_encode($data, JSON_UNESCAPED_UNICODE) . "\n";
        echo "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}







