<?php

namespace App\Policies;

use App\Models\User;
use App\Models\CashierShift;
use Illuminate\Auth\Access\HandlesAuthorization;

class CashierShiftPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the cashierShift can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasPermissionTo('list cashiershifts');
    }

    /**
     * Determine whether the cashierShift can view the model.
     */
    public function view(User $user, CashierShift $model): bool
    {
        return $user->hasPermissionTo('view cashiershifts');
    }

    /**
     * Determine whether the cashierShift can create models.
     */
    public function create(User $user): bool
    {
        return $user->hasPermissionTo('create cashiershifts');
    }

    /**
     * Determine whether the cashierShift can update the model.
     */
    public function update(User $user, CashierShift $model): bool
    {
        return $user->hasPermissionTo('update cashiershifts');
    }

    /**
     * Determine whether the cashierShift can delete the model.
     */
    public function delete(User $user, CashierShift $model): bool
    {
        return $user->hasPermissionTo('delete cashiershifts');
    }

    /**
     * Determine whether the user can delete multiple instances of the model.
     */
    public function deleteAny(User $user): bool
    {
        return $user->hasPermissionTo('delete cashiershifts');
    }

    /**
     * Determine whether the cashierShift can restore the model.
     */
    public function restore(User $user, CashierShift $model): bool
    {
        return false;
    }

    /**
     * Determine whether the cashierShift can permanently delete the model.
     */
    public function forceDelete(User $user, CashierShift $model): bool
    {
        return false;
    }
}
