<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Account;
use Illuminate\Auth\Access\HandlesAuthorization;

class AccountPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the account can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasPermissionTo('list accounts');
    }

    /**
     * Determine whether the account can view the model.
     */
    public function view(User $user, Account $model): bool
    {
        return $user->hasPermissionTo('view accounts');
    }

    /**
     * Determine whether the account can create models.
     */
    public function create(User $user): bool
    {
        return $user->hasPermissionTo('create accounts');
    }

    /**
     * Determine whether the account can update the model.
     */
    public function update(User $user, Account $model): bool
    {
        return $user->hasPermissionTo('update accounts');
    }

    /**
     * Determine whether the account can delete the model.
     */
    public function delete(User $user, Account $model): bool
    {
        return $user->hasPermissionTo('delete accounts');
    }

    /**
     * Determine whether the user can delete multiple instances of the model.
     */
    public function deleteAny(User $user): bool
    {
        return $user->hasPermissionTo('delete accounts');
    }

    /**
     * Determine whether the account can restore the model.
     */
    public function restore(User $user, Account $model): bool
    {
        return false;
    }

    /**
     * Determine whether the account can permanently delete the model.
     */
    public function forceDelete(User $user, Account $model): bool
    {
        return false;
    }
}
