<?php

namespace App\Models;

use App\Models\Scopes\Searchable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;


class TransactionFee extends Model
{
    protected $fillable = [
        'transaction_id',
        'fee_amount',
        'fee_type',
        'feeable_id',
        'feeable_type'
    ];

    public function feeable()
    {
        return $this->morphTo('feeable');
    }
    
    // Define relationship to AccountTransaction
    public function transaction()
    {
        return $this->belongsTo(AccountTransaction::class, 'transaction_id');
    }
}
