<?php

namespace App\Models;

use App\Models\Scopes\Searchable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Transaction extends Model
{
    use HasFactory;
    use Searchable;
    use LogsActivity;

    protected $fillable = [
        'cashier_shift_id',
        'transaction_date',
        'transaction_time',
        'transaction_amount',
        'transaction_type',
        'from_currency',
        'to_currency',
        'amount_given',
        'amount_received',
    ];

    protected $searchableFields = ['*'];

    protected $casts = [
        'transaction_date' => 'date',
    ];
    public function files()
    {
        return $this->morphMany(File::class, 'fileable');
    }

    public function accountTransactions()
    {
        return $this->hasMany(AccountTransaction::class, 'transaction_id');
    }

    // Define the polymorphic relationship
    public function fees()
    {
        return $this->morphMany(TransactionFee::class, 'feeable');
    }

    public function from_currency_code()
    {
        return $this->belongsTo(Currency::class, 'from_currency');
    }

    public function to_currency_code()
    {
        return $this->belongsTo(Currency::class, 'to_currency');
    }

    public function cashierShift()
    {
        return $this->belongsTo(CashierShift::class);
    }

    public function getDescriptionForEvent(string $modelName): string
    {
        return " {$this->title} Transaction was  {$modelName}";
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logExcept(['created_at', 'updated_at'])
            ->logOnlyDirty()
            ->setDescriptionForEvent(
                fn(string $modelName) => "Transaction has been {$modelName}"
            );
    }
}
