<?php

namespace App\Models;

use App\Models\Scopes\Searchable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Patient extends Model
{
    use HasFactory;
    use Searchable;
    use LogsActivity;

    protected $fillable = [
        'code',
        'name',
        'phone',
        'address',
    ];

    protected $searchableFields = ['*'];

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }

    public function histories()
    {
        return $this->hasMany(PatientHistory::class);
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logExcept(['created_at', 'updated_at'])
            ->logOnlyDirty()
            ->setDescriptionForEvent(
                fn(string $eventName) => "Patient has been {$eventName}"
            );
    }
}
