<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DailyBalanceReport extends Model
{
    use HasFactory;

    // DailyBalanceReport.php
    protected $fillable = [
    'report_date',
    'total_iqd',
    'total_usd',
    'total_euro',
    'euro_to_usd_rate',
    'converted_euro_to_usd',
    'additional_currencies',
    'total_additional_usd',
    'grand_total_usd',
    'profit_amount',
    'profit_currency',
    'usd_to_iqd_rate',
    'iqd_to_usd_rate',
    'converted_usd_to_iqd',
    'converted_iqd_to_usd',
    'image'
];

    protected $casts = [
        'additional_currencies' => 'array',
        'report_date' => 'date',
    ];
}
