<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CurrencyRateHistory extends Model
{
    use HasFactory;

    protected $table = 'currency_rate_history';

    protected $fillable = [
        'currency_id',
        'buy_rate',
        'sell_rate',
        'recorded_at',
    ];

    protected $casts = [
        'buy_rate' => 'decimal:2',
        'sell_rate' => 'decimal:2',
        'recorded_at' => 'datetime',
    ];

    /**
     * Get the currency that owns this history record
     */
    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    /**
     * Scope to get history for a specific currency
     */
    public function scopeForCurrency($query, $currencyId)
    {
        return $query->where('currency_id', $currencyId);
    }

    /**
     * Scope to get history within date range
     */
    public function scopeBetweenDates($query, $startDate, $endDate)
    {
        return $query->whereBetween('recorded_at', [$startDate, $endDate]);
    }

    /**
     * Scope to get recent history
     */
    public function scopeRecent($query, $days = 30)
    {
        return $query->where('recorded_at', '>=', now()->subDays($days));
    }
}

