<?php

namespace App\Models;

use App\Models\Scopes\Searchable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Currency extends Model
{
    use HasFactory;
    use Searchable;
    use LogsActivity;

    protected $fillable = ['currency_name', 'code', 'rate', 'type', 'use_division_for_buy','sort_order','buy_rate','sell_rate'];

    protected $searchableFields = ['*'];

    public function transactions()
    {
        return $this->hasMany(Transaction::class, 'from_currency');
    }

    public function transactions2()
    {
        return $this->hasMany(Transaction::class, 'to_currency');
    }

    public function accounts()
    {
        return $this->hasMany(Account::class);
    }

    public function getDescriptionForEvent(string $modelName): string
    {
        return " {$this->title} Currency was  {$modelName}";
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logExcept(['created_at', 'updated_at'])
            ->logOnlyDirty()
            ->setDescriptionForEvent(
                fn(string $modelName) => "Currency has been {$modelName}"
            );
    }
}
