<?php

namespace App\Models;

use App\Models\Scopes\Searchable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class CashierShift extends Model
{
    use HasFactory;
    use Searchable;
    use LogsActivity;

    protected $fillable = [
        'cashier_id',
        'supervisor_id',
        'start_time',
        'end_time',
        'starting_amount',
        'ending_amount',
    ];

    protected $searchableFields = ['*'];

    protected $table = 'cashier_shifts';

  // Relationship to Cashier (cashier_id)
  public function cashier()
  {
      return $this->belongsTo(Cashier::class, 'cashier_id');
  }

  // Relationship to User (supervisor_id)
  public function supervisor()
  {
      return $this->belongsTo(User::class, 'supervisor_id');
  }
  
    public function user()
    {
        return $this->belongsTo(User::class, 'supervisor_id');
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function getDescriptionForEvent(string $modelName): string
    {
        return " {$this->title} CashierShift was  {$modelName}";
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logExcept(['created_at', 'updated_at'])
            ->logOnlyDirty()
            ->setDescriptionForEvent(
                fn(string $modelName) => "CashierShift has been {$modelName}"
            );
    }
}
