<?php

namespace App\Models;

use App\Models\Scopes\Searchable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Cashier extends Model
{
    use HasFactory;
    use Searchable;
    use LogsActivity;

    protected $fillable = [
        'cashier_name',
        'user_id',
        'start_time',
        'end_time',
        'cashier_type',
    ];

    protected $searchableFields = ['*'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

   // Relationship to CashierShift (for both cashier and supervisor roles)
   public function cashierShifts()
   {
       return $this->hasMany(CashierShift::class, 'cashier_id');
   }

   public function supervisorShifts()
   {
       return $this->hasMany(CashierShift::class, 'supervisor_id');
   }

    public function getDescriptionForEvent(string $modelName): string
    {
        return " {$this->title} Cashier was  {$modelName}";
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logExcept(['created_at', 'updated_at'])
            ->logOnlyDirty()
            ->setDescriptionForEvent(
                fn(string $modelName) => "Cashier has been {$modelName}"
            );
    }
}
