<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppVersion extends Model
{
    use HasFactory;

    protected $fillable = [
        'version',
        'version_code',
        'platform',
        'release_notes',
        'download_url',
        'min_supported_version',
        'is_active',
        'is_force_update',
    ];

    protected $casts = [
        'version_code' => 'integer',
        'is_active' => 'boolean',
        'is_force_update' => 'boolean',
    ];

    /**
     * Scope to get active versions
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope to get versions by platform
     */
    public function scopeForPlatform($query, $platform)
    {
        return $query->where('platform', $platform);
    }

    /**
     * Scope to get latest version
     */
    public function scopeLatest($query)
    {
        return $query->orderBy('version_code', 'desc');
    }
}
