<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Transaction;

class TransactionFormReport extends Component
{
    public $transactions; // Store transactions to display

    public function mount()
    {
        $this->transactions = Transaction::with(['fees', 'from_currency_code', 'to_currency_code'])
            ->paginate(10)
            ->map(function ($transaction) {
                $fee = $transaction->fees->sum('fee_amount') ?? 0;
                $totalCostWithFee = $transaction->amount_given + $fee;
    
                $profitLoss = match ($transaction->transaction_type) {
                    'sell' => $transaction->amount_received - $totalCostWithFee,
                    'buy' => 0,
                    default => null,
                };
    
                return [
                    'id' => $transaction->id,
                    'type' => $transaction->transaction_type,
                    'amount_given' => $transaction->amount_given,
                    'given_currency' => $transaction->to_currency_code->currency_name ?? 'N/A', // Correct relationship
                    'amount_received' => $transaction->amount_received,
                    'received_currency' => $transaction->from_currency_code->currency_name ?? 'N/A', // Correct relationship
                    'fee' => $fee,
                    'profit_loss' => $profitLoss,
                    'cashier' => $transaction->cashierShift->cashier->cashier_name,
                    'date' => $transaction->transaction_date,
                    'time' => $transaction->transaction_time,
                ];
            });
    }
    



    public function render()
    {
        return view('livewire.transaction-form-report', [
            'transactions' => $this->transactions,
        ]);
    }
}
