<?php

namespace App\Livewire;

use App\Models\AccountTransaction as AccountTransactionModel;
use App\Models\Account;
use App\Models\Customer;
use App\Models\TransactionFee;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Carbon\Carbon;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\WithPagination;
use App\Models\Currency;
use Illuminate\Support\Str;

class ShowAccount extends Component
{

  public $account, $showModal = false, $showConvertModal = false;
  use LivewireAlert, WithPagination;
  public $operationType = 'multiply'; // Default to multiplication
  public $perPage = 5; // Load 5 transactions initially
  public $isLoading = false; // State to track loading

  // Create modal properties
  public $create_account_id, $create_person_name, $convert_note, $rate;
  public $create_transaction_amount;
  public $create_transaction_date;
  public $create_transaction_fee, $create_get_fee;
  public $create_transaction_time;
  public $create_note;
  public $account_selected;
  public $filters, $accountCurrencyId;
  public $selectedAccountId;
  public $newAccountCurrency;
  public $accounts; // List of customer accounts
  public $amountToConvert, $convertedAmount;
  public  $showCreateAccountModal;
  public $currency_id,$account_balance, $selected_customer_id;
  public $currencies = []; // Initialize as an array
  public $transactionTypes = ['transfer'];
  public $create_transaction_type = 'transfer'; // Set default to "transfer"

    public function mount($account)
    {
        // Check if the user is a customer
        if (Auth::user()->hasRole('customer')) {
            // Ensure the account belongs to the currently logged-in user
            $userAccounts = Auth::user()->customer->accounts;

            // Check if the requested account exists in the logged-in user's accounts
            if (!$userAccounts->contains($account)) {
                abort(403, 'Unauthorized access to this account');
            }
        }
        $this->currencies = Currency::all();

        if (request()->has('openModal')) {
            $this->showModal = true;
        }
        // For super-admin, cashier, and supervisor, they can access any account
        // No need to restrict access based on ownership

        // Proceed with the account data
        $this->account = $account;
        $this->accountCurrencyId = $account->currency_id; // Store the currency ID of the account
        $this->filters = [
            'to_account' => null,
        ];
    }
    public function selectCustomerForNewAccount($customerId)
    {
        $this->selected_customer_id = $customerId; 
        $this->showCreateAccountModal=true; 
    }

    public function createAccountForSelectedCustomer()
    {
        $this->validate([
            'currency_id' => 'required|exists:currencies,id',
        ]);

        $existingAccount = Account::where('customer_id', $this->selected_customer_id)
                                  ->where('currency_id', $this->currency_id)
                                  ->first();

        if ($existingAccount) {
            return $this->alert('error', 'موشتەری ئەم حسابەی هەیە پێویست ناکا دروستی بکەیەوە');
        }

        $lastAccount = Account::selectRaw('CAST(SUBSTRING(account_title, 3) AS UNSIGNED) AS number')
                              ->orderBy('number', 'desc')
                              ->first();

        $newAccountTitle = $lastAccount ? 'CN' . str_pad($lastAccount->number + 1, 5, '0', STR_PAD_LEFT) : 'CN00001';

        Account::create([
            'account_title' => $newAccountTitle,
            'account_number' => 'ACC' . str_pad(rand(1, 999999), 6, '0', STR_PAD_LEFT),
            'balance' => 0,
            'customer_id' => $this->selected_customer_id,
            'currency_id' => $this->currency_id,
            'account_type' => 'savings',
        ]);

        $this->customers = Customer::with('accounts')->paginate(50);
        $this->showCreateAccountModal = false; // Close the modal

        $this->alert('success', 'حسابەکە بە سەرکەوتووی دروستکرا');
    }


    public function openModal()
    {

        $this->showModal = true; // Open the modal
    }

  

    public function openConvertModal()
    {
        $this->showConvertModal = true;
    }

    public function closeConvertModal()
    {
        $this->rate = '';
        $this->convert_note = '';
        $this->selectedAccountId = null;
        $this->newAccountCurrency = null;
        $this->amountToConvert = null;
        $this->showConvertModal = false;
    }

    public function openCreateAccountModal()
    {
        $this->showCreateAccountModal = true; // Open the modal
    }

    public function closeCreateAccountModal()
    {
        $this->currency_id = '';
        $this->account_balance = '';
        $this->showCreateAccountModal = false; // Close the modal
    }


    public function saveConvert()
    {
        $this->amountToConvert = str_replace(',', '', $this->amountToConvert);
        $this->rate = str_replace(',', '', $this->rate);

        // to store unique GroupId 
        $transactionGroupId = Str::uuid();

        // Validation
        $this->validate([
            'selectedAccountId' => 'required|exists:accounts,id',
            'rate' => 'required',
            'amountToConvert' => 'required',
            'operationType' => 'required|in:multiply,divide',
        ]);

        // Find the selected account
        $fromAccount = $this->account;

        // if (!$fromAccount || $fromAccount->balance <= 0) {
        //     $this->alert('error', 'بەڵانسی پێویستت نیە بۆ ئەم شکاندنەوەیە!');
        //     return;
        // }

        // Calculate conversion based on operation type
        $convertedAmount = $this->operationType === 'multiply'
            ? $this->amountToConvert * $this->rate
            : $this->amountToConvert / $this->rate;

        $this->convertedAmount = $convertedAmount;
        // Ensure fromAccount has enough balance for the transaction
        // if ($this->operationType === 'multiply' && $fromAccount->balance < $this->amountToConvert) {
        //     $this->alert('error', 'بەڵانسی پێویستت نیە بۆ ئەم شکاندنەوەیە!');
        //     return;
        // }

        $fromAccount->balance -= $this->amountToConvert;

        // select main account to update 
        $MainCashBoxAccount = Account::where('currency_id', $fromAccount->currency_id)
            ->where('customer_id', 1)
            ->where('account_type', 'savings')
            ->first();
            
            
        // Update the target account
        $targetAccount = Account::findOrFail($this->selectedAccountId);
        $targetAccount->balance += $convertedAmount;

        // select main account to update target 
        $TargetCashBoxAccount = Account::where('currency_id', $targetAccount->currency_id)
            ->where('customer_id', 1)
            ->where('account_type', 'savings')
            ->first();    
        // dd($this->amountToConvert);
        
        $fromAccount->save();
        $targetAccount->save();

        // Create transaction records
        $currentDate = Carbon::now()->toDateString();
        $currentTime = Carbon::now()->toTimeString();

        // transaction for customer from account
        AccountTransactionModel::create([
            'from_account_id' => $fromAccount->id,
            'to_account_id' => $targetAccount->id,
            'person_name' => "شکانەوە لەسەر داواکاری خۆی",
            'get_fee' => $this->rate,
            'transaction_type' => 'withdrawal',
            'transaction_amount' => $this->amountToConvert,
            'transaction_date' => $currentDate,
            'transaction_time' => $currentTime,
            'note' => empty($this->convert_note) ? 'شکانەوە لەسەر داواکاری خۆی' : $this->convert_note,
            'user_id' => Auth::id(),
            'transaction_group_id' => $transactionGroupId,
        ]);
        // transaction for customer to account (target)
        AccountTransactionModel::create([
            'from_account_id' => $targetAccount->id,
            'to_account_id' => $fromAccount->id,
            'person_name' => "شکانەوە لەسەر داواکاری خۆی",
            'get_fee' => $this->rate,
            'transaction_type' => 'deposit',
            'transaction_amount' => $convertedAmount,
            'transaction_date' => $currentDate,
            'transaction_time' => $currentTime,
            'note' => empty($this->convert_note) ? 'شکانەوە لەسەر داواکاری خۆی' : $this->convert_note,
            'user_id' => Auth::id(),
            'transaction_group_id' => $transactionGroupId,
        ]);

        ////////////////////// Cashbox Transactions /////////////////////////////

         // transaction for cashbox from account
         AccountTransactionModel::create([
            'from_account_id' => $MainCashBoxAccount->id,
            'to_account_id' => $TargetCashBoxAccount->id,
            'person_name' => "شکانەوە لەسەر داواکاری خۆی",
            'get_fee' => $this->rate,
            'transaction_type' => 'withdrawal',
            'transaction_amount' => $this->amountToConvert,
            'transaction_date' => $currentDate,
            'transaction_time' => $currentTime,
            'note' => empty($this->convert_note) ? 'شکانەوە لەسەر داواکاری خۆی' : $this->convert_note,
            'user_id' => Auth::id(),
            'transaction_group_id' => $transactionGroupId,
        ]);
        // transaction for cashbox to account
        AccountTransactionModel::create([
            'from_account_id' => $TargetCashBoxAccount->id,
            'to_account_id' => $MainCashBoxAccount->id,
            'person_name' => "شکانەوە لەسەر داواکاری خۆی",
            'get_fee' => $this->rate,
            'transaction_type' => 'deposit',
            'transaction_amount' => $convertedAmount,
            'transaction_date' => $currentDate,
            'transaction_time' => $currentTime,
            'note' => empty($this->convert_note) ? 'شکانەوە لەسەر داواکاری خۆی' : $this->convert_note,
            'user_id' => Auth::id(),
            'transaction_group_id' => $transactionGroupId,
        ]);

        $this->alert('success', 'شکانەوەکە بە سەرکەوتووی ئەنجام درا !');
        $this->closeConvertModal();
    }


    private function getCurrencyIdByName($currencyName)
    {
        return \App\Models\Currency::where('currency_name', $currencyName)->value('id');
    }
    
    public function closeModal()
    {
        // $this->create_account_id = '';
        $this->create_person_name = '';
        $this->create_transaction_type = '';
        $this->create_transaction_amount = '';
        $this->create_transaction_date = '';
        $this->create_transaction_time = '';
        $this->create_transaction_fee = '';
        $this->create_note = '';
        // $this->reset(['from_account_id', 'to_account_id', 'transaction_amount', 'note']);
        $this->showModal = false; // Close the modal
    }

    protected $listeners = ['valueSelected', 'loadMore'];

    public function valueSelected($selectedValue, $identifier)
    {
        if (preg_match('/^[A-Za-z_][A-Za-z_0-9]*$/', $identifier)) {
            $this->$identifier = $selectedValue;
        }

        if (preg_match('/^[A-Za-z_][A-Za-z_0-9]*\.[A-Za-z_][A-Za-z_0-9]*$/', $identifier)) {
            // It's two words separated by a dot
            $parts = explode('.', $identifier);
            $array = $parts[0];
            $index = $parts[1];
            $this->$array[$index] = $selectedValue;
        }
    }
    public function loadMore()
    {
        $this->isLoading = true;
        $this->perPage += 5; // Increase the limit by 5
        $this->isLoading = false;
    }

    // old one

    public function saveCreate()
    {
        $this->create_transaction_amount = str_replace(',', '', $this->create_transaction_amount);
        $this->create_transaction_fee = str_replace(',', '', $this->create_transaction_fee);
        $this->create_get_fee = str_replace(',', '', $this->create_get_fee);
    
         // to store unique GroupId 
         $transactionGroupId = Str::uuid();

        // Validate the input fields
        $this->validate([
            'filters.account' => 'required|exists:accounts,id',
            'create_transaction_type' => 'required|in:transfer',
            'create_transaction_amount' => 'required|numeric',
            'create_transaction_fee' => 'required|numeric',
            'create_get_fee' => 'required|numeric',
            'create_person_name' => 'nullable|string',
            'create_note' => 'nullable|string',
        ]);
    
        // Retrieve the fromAccount (selected account) and toAccount
        $fromAccount = Account::findOrFail($this->account->id);
        $toAccount = Account::findOrFail($this->filters['account']);
    
        // Fetch the ProfitAccount (for fees) ensuring it matches the currency
        $ProfitAccount = Account::where('currency_id', $fromAccount->currency_id)
            ->where('customer_id', 1)
            ->where('account_type', 'profit')
            ->first();
    
        if (!$ProfitAccount) {
            $this->alert('error', 'Profit account not found!');
            return;
        }
    
        // Get current date and time
        $currentDate = Carbon::now()->toDateString(); // 'YYYY-MM-DD'
        $currentTime = Carbon::now()->toTimeString(); // 'HH:MM:SS'
    
        // Create the first transaction (From Account -> To Account)
        $transactionFrom = AccountTransactionModel::create([
            'from_account_id' => $fromAccount->id,
            'to_account_id' => $toAccount->id,
            'person_name' => $this->create_person_name,
            'get_fee' => $this->create_get_fee,
            'transaction_type' => 'withdrawal',
            'transaction_amount' => $this->create_transaction_amount + $this->create_get_fee,
            'transaction_date' => $currentDate,
            'transaction_time' => $currentTime,
            'note' => $this->create_note,
            'user_id' => Auth::id(),
            'transaction_group_id' => $transactionGroupId,
        ]);
    
        // Create the second transaction (To Account -> From Account)
        $transactionTo = AccountTransactionModel::create([
            'from_account_id' => $toAccount->id,
            'to_account_id' => $fromAccount->id,
            'person_name' => $this->create_person_name,
            'get_fee' => $this->create_transaction_fee,
            'transaction_type' => 'deposit',
            'transaction_amount' => $this->create_transaction_amount + $this->create_transaction_fee,
            'transaction_date' => $currentDate,
            'transaction_time' => $currentTime,
            'note' => $this->create_note,
            'user_id' => Auth::id(),
            'transaction_group_id' => $transactionGroupId,
        ]);
    
        // Create the third transaction (Profit Account -> Fee Record)
        $transactionProfit = AccountTransactionModel::create([
            'from_account_id' => $ProfitAccount->id, // Fee is deducted from the originating account
            'to_account_id' => $fromAccount->id, // Fee is credited to the profit account
            'person_name' => $this->create_person_name,
            'get_fee' => 0,
            'transaction_type' => 'deposit',
            'transaction_amount' => $this->create_get_fee - $this->create_transaction_fee, // Amount of the fee
            'transaction_date' => $currentDate,
            'transaction_time' => $currentTime,
            'note' => 'Fee collected for ' . $this->create_transaction_type,
            'user_id' => Auth::id(),
            'transaction_group_id' => $transactionGroupId,
        ]);
    
        // If there is a transaction fee, record it in the `transaction_fees` table
        if ($this->create_get_fee > 0) {
            // $transactionFrom->fees()->create([
            //     'fee_amount' => $this->create_get_fee,
            //     'fee_type' => 'transfer_fee', // 'transfer_fee'
            // ]);
    
            // $transactionTo->fees()->create([
            //     'fee_amount' => $this->create_transaction_fee,
            //     'fee_type' => 'transfer_fee', // 'transfer_fee'
            // ]);
    
            // $transactionProfit->fees()->create([
            //     'fee_amount' => $this->create_get_fee - $this->create_transaction_fee,
            //     'fee_type' => 'deposit_fee', // 'transfer_fee'
            // ]);
        }
    
        // Flash success message
        $this->alert('success', 'Transfer completed successfully!');
        $this->showModal = false;
    }
    

   
    public function render()
    {
        $account = $this->account;
        
        
        // Ensure conversion is calculated only if both values are valid numbers
        if (!empty($this->amountToConvert) && is_numeric($this->amountToConvert) &&
            !empty($this->rate) && is_numeric($this->rate)) {
            // Calculate conversion based on operation type
            $this->convertedAmount = $this->operationType === 'multiply'
                ? floatval($this->amountToConvert) * floatval($this->rate)
                : floatval($this->amountToConvert) / floatval($this->rate);
        } else {
            $this->convertedAmount = null; // Default to null if values are invalid
        }
        
        // Retrieve all transactions where the account is either from_account_id or to_account_id
        // Fetch related transactions with filtering, limited by $perPage
        $transactions = $account->relatedTransactions()
            ->where('transaction_type', '!=', 'fee') // Exclude fee transactions
            ->where('to_account_id', '!=', $account->id) // Exclude transactions to this account
            ->whereHas('from_account.customer', function ($query) {
                $query->where('id', '!=', 1); // Exclude customer ID 1
            })
            ->latest()
            ->take($this->perPage)
            ->get();

        // Calculate total deposit (assuming 'deposit' is the transaction_type for deposits)
        $totalDeposit = $transactions->where('transaction_type', 'deposit')
                                     ->sum('transaction_amount');
                                     
        // Calculate total withdrawal (assuming 'withdrawal' is the transaction_type for withdrawals)
        $totalWithdrawal = $transactions->where('transaction_type', 'withdrawal')
                                        ->sum('transaction_amount');
    
        return view('livewire.show-account', compact('transactions', 'account', 'totalDeposit', 'totalWithdrawal'));
    }
}
