<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\AccountTransaction;

class CustomerTransactions extends Component
{
    public $transactions;

    public function mount()
    {
        // Get the logged-in user's customer
        $customer = Auth::user()->customer;

        // If no customer is associated, set transactions as an empty array
        if (!$customer) {
            $this->transactions = [];
            return;
        }

        // Fetch all transactions for the customer's accounts
        $this->transactions = AccountTransaction::whereIn('from_account_id', $customer->accounts()->pluck('id'))
                                ->orderBy('created_at', 'desc')
                                ->get();
    }

    public function render()
    {
        return view('livewire.customer-transactions', [
            'transactions' => $this->transactions,
        ]);
    }
}
