<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Currency;

class CurrencyOrder extends Component
{
    public $currencies;

    public function mount()
    {
        // Fetch currencies sorted by sort_order, including the image path
        $this->currencies = Currency::orderBy('sort_order')
            ->select('id', 'currency_name', 'code') // Ensure currency_image is selected
            ->get()
            ->toArray();
    }
    

    public function updateOrder($orderedIds)
    {
        // Update the sort_order for each currency
        foreach ($orderedIds as $index => $id) {
            Currency::where('id', $id)->update(['sort_order' => $index]);
        }

        // Refresh the list to reflect changes
        $this->currencies = Currency::orderBy('sort_order')->get()->toArray();
    }

    public function render()
    {
        return view('livewire.currency-order');
    }
}
