<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Account;
use App\Models\Currency;

class CreateOwnerAccounts extends Component
{
    public $currencies;
    public $existingAccounts;
    public $successMessage;
    public $allCreated = false;

    public function mount()
    {
        $this->loadData();
    }

    public function loadData()
    {
        $this->currencies = Currency::all();
        $this->existingAccounts = Account::where('account_title', 'Business Owner Cashbox')->get();

        // Check if all currencies already have accounts
        $this->allCreated = $this->currencies->every(fn($currency) => 
            $this->existingAccounts->contains('currency_id', $currency->id)
        );
    }

    public function createAccounts()
    {
        foreach ($this->currencies as $currency) {
            // Check if an account already exists for this currency
            if (!$this->existingAccounts->contains('currency_id', $currency->id)) {
                Account::create([
                    'account_title' => 'Business Owner Cashbox',
                    'account_number' => 'BO-' . strtoupper($currency->currency_name) . '-' . time(),
                    'balance' => 0,
                    'customer_id' => null, // No customer
                    'currency_id' => $currency->id,
                    'account_type' => 'savings',
                ]);
            }
        }

        $this->successMessage ='بەسەرکەوتووی دروستکرا'; 
        $this->loadData(); // Reload data to update UI
    }

    public function render()
    {
        return view('livewire.create-owner-accounts');
    }
}
