<?php

namespace App\Livewire\Components;

use Livewire\Component;

class CustomSelectSale extends Component
{
    // CustomSelectSale.php
    public $identifier;
    public $selectedValue = '';
    public $selectedLabel = '';


    public $search;
    public $options;
    public $default;

    public $label;
    public $placeholder;

    public $class;
    public $btnclass;

    public $height;
    public $disabled;

    public $disabledOptions;

    public function mount(
        $identifier,
        $options,
        $default = null,

        $label = null,
        $placeholder = null,

        $class = null,
        $btnclass = null,

        $height = null,
        $disabled = false,

        $disabledOptions = null,
        )
    {
        $this->identifier = $identifier;
        $this->options = $options;
        $this->selectedValue = $default;

        $this->label = $label;
        $this->placeholder = $placeholder;

        $this->class = $class ?? 'form-control';
        $this->btnclass = $btnclass ?? 'btn btn-outline-primary';

        $this->height = $height;
        $this->disabled = $disabled;

        $this->disabledOptions = $disabledOptions ? $disabledOptions : collect([]);
    }

    public function selectValue($value)
    {
        $this->selectedValue = $value;
        $this->dispatch('valueSelected', $this->selectedValue, $this->identifier);
        $this->clear();
    }

    private function search($searchString)
    {
        if (empty($searchString) || $this->options->isEmpty()) {
            return $this->options;
        }

        return $this->options->filter(function ($item, $key) use ($searchString) {
            return stristr($item, $searchString);
        });
    }


    public function clear()
    {
        $this->selectedValue = '';
       // $this->search = '';
    }

    public function render()
    {

        $results = $this->search($this->search);
        return view('livewire.components.custom-select-sale',[
            'results' => $results
        ]);
    }
}