<?php

namespace App\Livewire;

use Livewire\Component;
use App\Traits\HasUtf8Encoding;

abstract class BaseComponent extends Component
{
    use HasUtf8Encoding;

    /**
     * Ensure proper UTF-8 encoding for all properties
     */
    public function hydrate()
    {
        $this->encodeAllProperties();
    }

    /**
     * Ensure proper UTF-8 encoding before rendering
     */
    public function dehydrate()
    {
        $this->encodeAllProperties();
    }

    /**
     * Ensure proper UTF-8 encoding before updating
     */
    public function updating($property, $value)
    {
        if (is_string($value)) {
            $this->$property = $this->ensureUtf8Encoding($value);
        }
    }

    /**
     * Ensure proper UTF-8 encoding after updating
     */
    public function updated($property, $value)
    {
        if (is_string($value)) {
            $this->$property = $this->ensureUtf8Encoding($value);
        }
    }

    /**
     * Ensure proper UTF-8 encoding for all data before rendering
     */
    protected function prepareDataForRender($data)
    {
        return $this->ensureUtf8Encoding($data);
    }

    /**
     * Get the view / contents that represent the component.
     */
    abstract public function render();
}

