<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\DailyBalanceReport;

class BalanceReports extends Component
{
    public $showModal = false;
    public $selectedReport;
    public $selectedReportId;

    public function showReport($id)
    {
        $this->selectedReportId = $id;
        $this->selectedReport = DailyBalanceReport::find($id);
        $this->showModal = true;
    }

    public function render()
    {
        $reports = DailyBalanceReport::orderBy('report_date', 'desc')->paginate(30);
        
        return view('livewire.balance-reports', [
            'reports' => $reports
        ]);
    }
}