<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CustomerStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'customer_name' => ['required', 'max:255', 'string'],
            'phone_number' => ['required', 'max:255', 'string'],
            'second_phone' => ['nullable', 'max:255', 'string'],
            'address' => ['required', 'max:255', 'string'],
            'note' => ['required', 'max:255', 'string'],
        ];
    }
}
