<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CashierStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'cashier_name' => ['required', 'string', 'max:255', 'unique:cashiers,cashier_name'],
            'cashier_type' => ['required', 'in:supervisor,cashier'],
            // 'start_time' => ['required', 'date_format:H:i'], // or H:i:s if seconds are needed
            // 'end_time' => ['required', 'date_format:H:i', 'after:start_time'],
            
        ];
    }
}
