<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CashierShiftStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'cashier_id' => ['required', 'exists:cashiers,id'],
            'supervisor_id' => ['required', 'exists:users,id'],
            'start_time' => ['required', 'date_format:H:i:s'],
            'end_time' => ['required', 'date_format:H:i:s'],
            'starting_amount' => ['required', 'numeric'],
            'ending_amount' => ['required', 'numeric'],
        ];
    }
}
