<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AccountStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'account_number' => ['required', 'max:255', 'string'],
            'balance' => ['required', 'numeric'],
            'customer_id' => ['required', 'exists:customers,id'],
            'account_type' => ['required', 'in:savings,checking'],
        ];
    }
}
