<?php

namespace App\Http\Controllers\language;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Config;

use Illuminate\Support\Facades\Cookie;

class LanguageController extends Controller
{


  public function swap($locale = null)
  {
      // Default to 'en' if no locale is provided
      if (!$locale) {
          $locale = 'en';
      }

      // Validate the locale
      if (!in_array($locale, ['en', 'ku'])) {
          abort(400);
      } else {
          // Determine if the selected locale is RTL (only Kurdish is RTL)
          $isRTL = ($locale === 'ku');
          session()->put('myRTLMode', $isRTL);

          // Store RTL mode and language in cookies (valid for 1 year)
          Cookie::queue('myRTLMode', $isRTL, 525600); // 525600 minutes = 1 year
          Cookie::queue('locale', $locale, 525600); // 525600 minutes = 1 year

          // Set the locale for the application
          App::setLocale($locale);
          session()->put('locale', $locale);
      }

      return redirect()->back();
  }

}
