<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AppVersionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        // Check if user has super-admin role
        if (!Auth::check() || !Auth::user()->hasRole('super-admin')) {
            abort(403, 'Access denied. Super-admin role required.');
        }

        return view('app.app-versions.index');
    }
}
